/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Random;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

class Life
extends JFrame
implements ActionListener,
MouseListener {
    boolean[] bArray = new boolean[]{false, false, false, true, false, false, false, false, false};
    boolean[] sArray = new boolean[]{false, false, true, true, false, false, false, false, false};
    int delay = 1000;
    int generation = 0;
    double random = 0.0;
    static boolean isAdopted = false;
    boolean isStarted = false;
    boolean mouseFlag = false;
    boolean isOver = false;
    int vertical;
    int horizontal;
    int aliveI;
    int aliveO;
    boolean[][] arrayF;
    static boolean[][] arrayP;
    LifePanel lifePanel;
    JRadioButton[] bButton;
    JRadioButton[] sButton;
    JButton changeButton;
    JButton innerButton;
    JButton outerButton;
    JButton adoptButton;
    JButton startButton;
    JTextField verticalText;
    JTextField horizontalText;
    JTextField timeText;
    JTextField randomText;
    JLabel fieldLabel;
    Timer timer;
    Random r = new Random();

    public static void main(String[] stringArray) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        Life life = new Life();
        life.setVisible(true);
    }

    Life() {
        this.setTitle("\u3000\u3000\u3000Conway's Game of Life\u3000\u3000\u3000ver2.0\u3000\u3000\u3000");
        this.setSize(1215, 750);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        JSplitPane jSplitPane = new JSplitPane(1, true);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerSize(10);
        jSplitPane.setDividerLocation(0.4);
        this.lifePanel = new LifePanel();
        this.lifePanel.addMouseListener(this);
        this.lifePanel.add(Box.createRigidArea(this.lifePanel.getPreferredSize()));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.lifePanel, gridBagConstraints);
        jPanel.add(this.lifePanel);
        JLabel jLabel = new JLabel(" B   :   ");
        this.bButton = new JRadioButton[9];
        for (int i = 0; i < 9; ++i) {
            this.bButton[i] = new JRadioButton(Integer.toString(i));
            if (!this.bArray[i]) continue;
            this.bButton[i].setSelected(true);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(jLabel);
        for (int i = 0; i < 9; ++i) {
            jPanel2.add(this.bButton[i]);
        }
        JLabel jLabel2 = new JLabel(" S   :   ");
        this.sButton = new JRadioButton[9];
        for (int i = 0; i < 9; ++i) {
            this.sButton[i] = new JRadioButton(Integer.toString(i));
            if (!this.sArray[i]) continue;
            this.sButton[i].setSelected(true);
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(jLabel2);
        for (int i = 0; i < 9; ++i) {
            jPanel3.add(this.sButton[i]);
        }
        JLabel jLabel3 = new JLabel(" 1\u4e16\u4ee3\u306e\u6642\u9593( msec )   :   ");
        this.timeText = new JTextField(Integer.toString(this.delay), 10);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jLabel3);
        jPanel4.add(this.timeText);
        JLabel jLabel4 = new JLabel(" \u300c\u6b7b\u300d\u304b\u3089\u300c\u751f\u300d\u3078\u306e\u30e9\u30f3\u30c0\u30e0\u767a\u751f\u7387( % )   :   ");
        this.randomText = new JTextField(Double.toString(this.random), 7);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(jLabel4);
        jPanel5.add(this.randomText);
        this.changeButton = new JButton("\u5909\u66f4");
        this.changeButton.addActionListener(this);
        this.changeButton.setActionCommand("change");
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(new TitledBorder(new BevelBorder(1), "\u30eb\u30fc\u30eb", 1, 2));
        jPanel6.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel6.add(jPanel2);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel6.add(jPanel3);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel6.add(jPanel4);
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel6.add(jPanel5);
        gridBagLayout.setConstraints(this.changeButton, gridBagConstraints);
        jPanel6.add(this.changeButton);
        JLabel jLabel5 = new JLabel(" \u7e26\u306e\u30bb\u30eb   (   2   ~   100   )   :   ");
        JLabel jLabel6 = new JLabel(" \u6a2a\u306e\u30bb\u30eb   (   2   ~   100   )   :   ");
        this.verticalText = new JTextField(4);
        this.horizontalText = new JTextField(4);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        jPanel7.add(jLabel5);
        jPanel7.add(this.verticalText);
        jPanel7.add(jLabel6);
        jPanel7.add(this.horizontalText);
        this.innerButton = new JButton("\u5185\u5074\u306e\u30bb\u30eb\u3092\u6bba\u3059");
        this.innerButton.addActionListener(this);
        this.innerButton.setActionCommand("inner");
        this.outerButton = new JButton("\u5916\u5074\u306e\u30bb\u30eb\u3092\u6bba\u3059");
        this.outerButton.addActionListener(this);
        this.outerButton.setActionCommand("outer");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        jPanel8.add(this.innerButton);
        jPanel8.add(this.outerButton);
        this.adoptButton = new JButton("\u9069\u7528");
        this.adoptButton.addActionListener(this);
        this.adoptButton.setActionCommand("adopt");
        this.startButton = new JButton("\u958b\u59cb");
        this.startButton.addActionListener(this);
        this.startButton.setActionCommand("start");
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 0));
        jPanel9.add(this.adoptButton);
        jPanel9.add(this.startButton);
        this.fieldLabel = new JLabel("\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(new TitledBorder(new BevelBorder(1), "\u30d5\u30a3\u30fc\u30eb\u30c9", 1, 2));
        jPanel10.setLayout(gridBagLayout);
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        jPanel10.add(jPanel7);
        gridBagLayout.setConstraints(jPanel8, gridBagConstraints);
        jPanel10.add(jPanel8);
        gridBagLayout.setConstraints(jPanel9, gridBagConstraints);
        jPanel10.add(jPanel9);
        gridBagLayout.setConstraints(this.fieldLabel, gridBagConstraints);
        jPanel10.add(this.fieldLabel);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 1));
        jPanel11.add(jPanel6);
        jPanel11.add(jPanel10);
        jSplitPane.setLeftComponent(jPanel11);
        jSplitPane.setRightComponent(jPanel);
        this.add(jSplitPane);
        this.innerButton.setEnabled(false);
        this.outerButton.setEnabled(false);
        this.startButton.setEnabled(false);
        this.timer = new Timer(this.delay, this);
        this.timer.setActionCommand("timer");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block53: {
            String string = actionEvent.getActionCommand();
            if (string.equals("inner")) {
                this.mouseFlag = false;
                for (int i = 1; i < this.arrayF.length - 1; ++i) {
                    for (int j = 1; j < this.arrayF[0].length - 1; ++j) {
                        this.arrayF[i][j] = false;
                        Life.arrayP[i][j] = this.arrayF[i][j];
                    }
                }
                this.aliveI = 0;
                this.fieldLabel.setText(this.generation + "   \u4e16\u4ee3\u76ee   ,   \u5185\u306e\u500b\u4f53\u6570   " + this.aliveI + "   /   " + (this.arrayF.length - 2) * (this.arrayF[0].length - 2) + "   ,   \u5916\u306e\u500b\u4f53\u6570   " + this.aliveO + "   /   " + (2 * this.arrayF.length + 2 * this.arrayF[0].length - 4));
                this.lifePanel.repaint();
                this.mouseFlag = true;
            } else if (string.equals("outer")) {
                this.mouseFlag = false;
                for (int i = 0; i < this.arrayF.length; ++i) {
                    for (int j = 0; j < this.arrayF[0].length; ++j) {
                        if (i != 0 && j != 0 && i != this.arrayF.length - 1 && j != this.arrayF[0].length - 1) continue;
                        this.arrayF[i][j] = false;
                        Life.arrayP[i][j] = this.arrayF[i][j];
                    }
                }
                this.aliveO = 0;
                this.fieldLabel.setText(this.generation + "   \u4e16\u4ee3\u76ee   ,   \u5185\u306e\u500b\u4f53\u6570   " + this.aliveI + "   /   " + (this.arrayF.length - 2) * (this.arrayF[0].length - 2) + "   ,   \u5916\u306e\u500b\u4f53\u6570   " + this.aliveO + "   /   " + (2 * this.arrayF.length + 2 * this.arrayF[0].length - 4));
                this.lifePanel.repaint();
                this.mouseFlag = true;
            } else {
                if (string.equals("change")) {
                    int n;
                    for (n = 0; n < 9; ++n) {
                        this.bArray[n] = this.bButton[n].isSelected();
                    }
                    for (n = 0; n < 9; ++n) {
                        this.sArray[n] = this.sButton[n].isSelected();
                    }
                    try {
                        this.delay = Integer.parseInt(this.timeText.getText());
                        if (this.delay < 0) {
                            JOptionPane.showMessageDialog(this, "\u30a8\u30e9\u30fc!   - \u5024\u304c\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059", "\u30a8\u30e9\u30fc", 0);
                            this.timeText.requestFocusInWindow();
                            this.timeText.selectAll();
                            return;
                        }
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(this, "\u30a8\u30e9\u30fc!   - \u6b63\u3057\u3044\u5024\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044", "\u30a8\u30e9\u30fc", 0);
                        this.timeText.requestFocusInWindow();
                        this.timeText.selectAll();
                        return;
                    }
                    this.timer.setInitialDelay(this.delay);
                    this.timer.setDelay(this.delay);
                    try {
                        this.random = Double.parseDouble(this.randomText.getText());
                        if (this.random < 0.0 || this.random > 100.0) {
                            JOptionPane.showMessageDialog(this, "\u30a8\u30e9\u30fc!   - \u5024\u304c\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059", "\u30a8\u30e9\u30fc", 0);
                            this.randomText.requestFocusInWindow();
                            this.randomText.selectAll();
                            return;
                        }
                        break block53;
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(this, "\u30a8\u30e9\u30fc!   - \u6b63\u3057\u3044\u5024\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044", "\u30a8\u30e9\u30fc", 0);
                        this.randomText.requestFocusInWindow();
                        this.randomText.selectAll();
                        return;
                    }
                }
                if (string.equals("adopt")) {
                    try {
                        this.vertical = Integer.parseInt(this.verticalText.getText());
                        if (this.vertical < 2 || this.vertical > 100) {
                            JOptionPane.showMessageDialog(this, "\u30a8\u30e9\u30fc!   - \u5024\u304c\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059", "\u30a8\u30e9\u30fc", 0);
                            this.verticalText.requestFocusInWindow();
                            this.verticalText.selectAll();
                            return;
                        }
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(this, "\u30a8\u30e9\u30fc!   - \u6b63\u3057\u3044\u5024\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044", "\u30a8\u30e9\u30fc", 0);
                        this.verticalText.requestFocusInWindow();
                        this.verticalText.selectAll();
                        return;
                    }
                    try {
                        this.horizontal = Integer.parseInt(this.horizontalText.getText());
                        if (this.horizontal < 2 || this.horizontal > 100) {
                            JOptionPane.showMessageDialog(this, "\u30a8\u30e9\u30fc!   - \u5024\u304c\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059", "\u30a8\u30e9\u30fc", 0);
                            this.horizontalText.requestFocusInWindow();
                            this.horizontalText.selectAll();
                            return;
                        }
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(this, "\u30a8\u30e9\u30fc!   - \u6b63\u3057\u3044\u5024\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044", "\u30a8\u30e9\u30fc", 0);
                        this.horizontalText.requestFocusInWindow();
                        this.horizontalText.selectAll();
                        return;
                    }
                    this.arrayF = new boolean[this.vertical + 2][this.horizontal + 2];
                    arrayP = new boolean[this.arrayF.length][this.arrayF[0].length];
                    for (int i = 0; i < this.arrayF.length; ++i) {
                        for (int j = 0; j < this.arrayF[i].length; ++j) {
                            this.arrayF[i][j] = false;
                            Life.arrayP[i][j] = this.arrayF[i][j];
                        }
                    }
                    LifePanel.X = this.lifePanel.getPreferredSize().getHeight() / (double)arrayP.length;
                    LifePanel.Y = this.lifePanel.getPreferredSize().getWidth() / (double)arrayP[0].length;
                    this.innerButton.setEnabled(true);
                    this.outerButton.setEnabled(true);
                    this.startButton.setEnabled(true);
                    this.adoptButton.setEnabled(false);
                    this.verticalText.setEnabled(false);
                    this.horizontalText.setEnabled(false);
                    isAdopted = true;
                    this.lifePanel.repaint();
                    this.aliveI = 0;
                    this.aliveO = 0;
                    this.fieldLabel.setText(this.generation + "   \u4e16\u4ee3\u76ee   ,   \u5185\u306e\u500b\u4f53\u6570   " + this.aliveI + "   /   " + (this.arrayF.length - 2) * (this.arrayF[0].length - 2) + "   ,   \u5916\u306e\u500b\u4f53\u6570   " + this.aliveO + "   /   " + (2 * this.arrayF.length + 2 * this.arrayF[0].length - 4));
                    this.mouseFlag = true;
                } else if (string.equals("start")) {
                    if (this.isStarted) {
                        this.timer.stop();
                        this.startButton.setText("\u958b\u59cb");
                        this.innerButton.setEnabled(true);
                        this.outerButton.setEnabled(true);
                        this.changeButton.setEnabled(true);
                        this.isStarted = false;
                        this.mouseFlag = true;
                    } else {
                        if (this.isOver) {
                            this.generation = 0;
                        }
                        this.startButton.setText("\u505c\u6b62");
                        this.innerButton.setEnabled(false);
                        this.outerButton.setEnabled(false);
                        this.changeButton.setEnabled(false);
                        this.isStarted = true;
                        this.mouseFlag = false;
                        this.timer.start();
                    }
                } else if (string.equals("timer")) {
                    int n;
                    int n2;
                    this.timer.stop();
                    ++this.generation;
                    int n3 = 0;
                    int n4 = 0;
                    this.aliveI = 0;
                    for (n2 = 1; n2 < this.arrayF.length - 1; ++n2) {
                        for (n = 1; n < this.arrayF[n2].length - 1; ++n) {
                            if (this.arrayF[n2 - 1][n - 1]) {
                                ++n3;
                            }
                            if (this.arrayF[n2][n - 1]) {
                                ++n3;
                            }
                            if (this.arrayF[n2 + 1][n - 1]) {
                                ++n3;
                            }
                            if (this.arrayF[n2 - 1][n]) {
                                ++n3;
                            }
                            if (this.arrayF[n2 + 1][n]) {
                                ++n3;
                            }
                            if (this.arrayF[n2 - 1][n + 1]) {
                                ++n3;
                            }
                            if (this.arrayF[n2][n + 1]) {
                                ++n3;
                            }
                            if (this.arrayF[n2 + 1][n + 1]) {
                                ++n3;
                            }
                            for (int i = 0; i < 9; ++i) {
                                if (!this.arrayF[n2][n]) {
                                    if (!this.bArray[i] || i != n3) continue;
                                    Life.arrayP[n2][n] = true;
                                    continue;
                                }
                                if (this.sArray[i] || i != n3) continue;
                                Life.arrayP[n2][n] = false;
                            }
                            if (!arrayP[n2][n] && this.random / 100.0 > this.r.nextDouble()) {
                                Life.arrayP[n2][n] = true;
                            }
                            if (arrayP[n2][n]) {
                                ++this.aliveI;
                            }
                            n3 = 0;
                        }
                    }
                    for (n2 = 1; n2 < this.arrayF.length - 1; ++n2) {
                        for (n = 1; n < this.arrayF[n2].length - 1; ++n) {
                            if (arrayP[n2][n] == this.arrayF[n2][n]) {
                                ++n4;
                            }
                            this.arrayF[n2][n] = arrayP[n2][n];
                        }
                    }
                    this.lifePanel.repaint();
                    if (n4 < (this.arrayF.length - 2) * (this.arrayF[0].length - 2)) {
                        this.fieldLabel.setText(this.generation + "   \u4e16\u4ee3\u76ee   ,   \u5185\u306e\u500b\u4f53\u6570   " + this.aliveI + "   /   " + (this.arrayF.length - 2) * (this.arrayF[0].length - 2) + "   ,   \u5916\u306e\u500b\u4f53\u6570   " + this.aliveO + "   /   " + (2 * this.arrayF.length + 2 * this.arrayF[0].length - 4));
                        this.timer.start();
                    } else if (this.random == 0.0) {
                        this.fieldLabel.setText(" Game Over - " + --this.generation + "   \u4e16\u4ee3\u76ee   ,   \u5185\u306e\u500b\u4f53\u6570   " + this.aliveI + "   /   " + (this.arrayF.length - 2) * (this.arrayF[0].length - 2) + "   ,   \u5916\u306e\u500b\u4f53\u6570   " + this.aliveO + "   /   " + (2 * this.arrayF.length + 2 * this.arrayF[0].length - 4));
                        this.timer.stop();
                        this.isOver = true;
                        this.startButton.setText("\u958b\u59cb");
                        this.innerButton.setEnabled(true);
                        this.outerButton.setEnabled(true);
                        this.changeButton.setEnabled(true);
                        this.isStarted = false;
                        this.mouseFlag = true;
                    }
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (isAdopted && !this.isStarted && this.mouseFlag) {
            this.mouseFlag = false;
            int n = (int)(mouseEvent.getPoint().getX() / LifePanel.X);
            int n2 = (int)(mouseEvent.getPoint().getY() / LifePanel.Y);
            this.arrayF[n][n2] = !this.arrayF[n][n2];
            Life.arrayP[n][n2] = this.arrayF[n][n2];
            this.lifePanel.repaint();
            if (this.arrayF[n][n2]) {
                if (n == 0 || n2 == 0 || n == this.arrayF.length - 1 || n2 == this.arrayF[0].length - 1) {
                    ++this.aliveO;
                } else {
                    ++this.aliveI;
                }
            } else if (n == 0 || n2 == 0 || n == this.arrayF.length - 1 || n2 == this.arrayF[0].length - 1) {
                --this.aliveO;
            } else {
                --this.aliveI;
            }
            this.fieldLabel.setText(this.generation + "   \u4e16\u4ee3\u76ee   ,   \u5185\u306e\u500b\u4f53\u6570   " + this.aliveI + "   /   " + (this.arrayF.length - 2) * (this.arrayF[0].length - 2) + "   ,   \u5916\u306e\u500b\u4f53\u6570   " + this.aliveO + "   /   " + (2 * this.arrayF.length + 2 * this.arrayF[0].length - 4));
            this.mouseFlag = true;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

